@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content ">
		<div class="container-fluid">
			<div class="row pt-3">
				<div class="col-lg-3 col-md-6 col-12">
					<div class="card border-0 shadow-custom">
						<a href="{{ route('reports.payment_transactions') }}">
							<div class="card-body">
								<div class="d-flex justify-content-between align-items-center">
									<div class="content">
										<p class="text-dark text-lg mb-0  title">{{ format_amount($earnings) }}</p>
										<p class="card-name mb-0 text-secondary  sub-title ">{{
											__('dashboard.earnings') }}</p>
									</div>

									<div class="text-primary icon">
										<i class="fas fa-money-bill-alt fa-3x"></i>
									</div>
								</div>
							</div>
						</a>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<a href="{{ route('member.index') }}">
						<div class="card border-0 shadow-custom">
							<div class="card-body">
								<div class="d-flex justify-content-between align-items-center">
									<div class="content">
										<p class="text-dark text-lg mb-0   title">{{ $total_members }}</p>
										<p class="card-name text-secondary mb-0  sub-title">{{
											__('dashboard.total') }}</p>
									</div>

									<div class="text-primary icon">
										<i class="fas fa-list fa-3x"></i>
									</div>
								</div>
							</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<a href="{{ route('reports.member_information') }}">
						<div class="card border-0 shadow-custom">
							<div class="card-body">
								<div class="d-flex justify-content-between align-items-center">
									<div class="content">
										<p class="text-dark text-lg mb-0 title">{{ $new_members }}</p>
										<p class="card-name text-secondary mb-0  sub-title">{{
											__('dashboard.total_joined') }}</p>
									</div>

									<div class="text-primary  icon">
										<i class="fas fa-link fa-3x"></i>
									</div>
								</div>
							</div>
						</div>
					</a>
				</div>
				<div class="col-lg-3 col-md-6 col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-center">
								<div class="content">
									<p class="text-lg mb-0 text-dark title">{{ $dashboard_time }}</p>
									<p class="card-name text-secondary mb-0  sub-title">{{ $dashboard_date }}
									</p>
								</div>

								<div class="text-primary icon">
									<i class="fas fa-calendar-alt fa-3x"></i>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-8 col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">	
							<h3 class="card-title">
								{{ __('dashboard.transactions_overview', ['from' => format_date($date1), 'to' =>
								format_date($date2)]) }}
							</h3>
						</div>
						<div class="card-body">
							<canvas id="sales-chart" class="bar-chart-dashbord"></canvas>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-12">
					<div class="card border-0 shadow-custom ">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('dashboard.latest_members') }}
							</h3>
						</div>
						<div class="card-body px-0 ">
							<ul class="users-list clearfix mb-0 bar-chart-dashbord">
								@if(count($latest_members) > 0)
									@foreach ($latest_members as $member)
									<li>
										<a class="users-list-name" href="{{ route('member.edit', $member->id) }}">
											<div class="d-flex justify-content-center mb-1">
												<div class="users-list-image elevation-1"
													style="background-image: url('{{ get_image_path($member->profile_picture) }}');">
												</div>
											</div>
											<span class="text-secondary">{{ $member->name }}</span>
											<span class="users-list-date">{{ format_date($member->created_at) }}</span>
										</a>
									</li>
									@endforeach
								@else
								<div class="d-flex justify-content-center align-items-center h-100">
									<p class="text-center mb-0">{{ __('dashboard.no_record_found') }}</p>
								</div>
								@endif
							</ul>
						</div>
					</div>
				</div>
				<div class="col-lg-12 ">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<div class="d-flex align-items-center justify-content-between">
								<h3 class="card-title">
									{{ __('dashboard.latest_transactions') }}
								</h3>
								<a href="{{ route('reports.payment_transactions')}}" class="btn btn-primary btn-sm">{{
									__('dashboard.view_all') }}</a>
							</div>
						</div>
						<div class="card-body table-responsive">
							<table class="table custom-table-bordered table-valign-middle">
								<thead>
									<tr>
										<th class="nowrap">{{ __('dashboard.th_transaction_type') }}</th>
										<th class="nowrap">{{ __('dashboard.th_payment_method') }}</th>
										<th class="nowrap">{{ __('dashboard.th_dr_cr') }}</th>
										<th class="nowrap">{{ __('dashboard.th_amount') }}</th>
										<th class="fixed-width-td nowrap">{{ __('dashboard.th_date') }}</th>
									</tr>
								</thead>
								<tbody>
									@foreach($latest_transactions as $transaction)
										<tr>
											<td class="nowrap text-capitalize">{{ $transaction->type }}</td>
											<td class="nowrap text-capitalize">{{ $transaction->method }}</td>
											<td class="nowrap text-capitalize">{{ $transaction->dr_cr }}</td>
											<td class="align-middle">{!! transaction_type($transaction) !!}</td>
											<td class="nowrap">{{ format_date($transaction->date) }}</td>	
										</tr>
									@endforeach
									@if(count($latest_transactions) == 0)
									<tr>
										<td colspan="9">
											<p class="text-center mb-0">{{ __('dashboard.no_record_found') }}</p>
										</td>
									</tr>
									@endif
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@stop
@section('js-script')
<script>
	$(function () {
		'use strict'

		var ticksStyle = {


		}

		var mode = 'index'
		var intersect = true

		var $salesChart = $('#sales-chart')
		var salesChart = new Chart($salesChart, {
			type: 'bar',
			data: {
				labels: ['SUN', 'MON', 'TUE', 'WED', 'THURS', 'FRI', 'SAT'],
				datasets: [
					{
						label: 'Plus Transactions ({{ $currency_symbol }})',
						backgroundColor: '#28a745',
						borderColor: '#28a745',
						fill: false,
						data: @json($chart_data['income']),
					},
					{
						label: 'Minus Transactions ({{ $currency_symbol }})',
						backgroundColor: '#e74a3b',
						fill: false,
						data: @json($chart_data['expense'])
					},
				]
			},
			options: {
				maintainAspectRatio: false,
				tooltips: {
					mode: mode,
					intersect: intersect
				},
				hover: {
					mode: mode,
					intersect: intersect
				},
				legend: {
					display: true
				},
				scales: {
					yAxes: [{
						display: true,
						gridLines: {
							display: true
						},

						ticks: $.extend({
							beginAtZero: true,
							callback: function (value) {
								if (value >= 1000) {
									value /= 1000
									value += 'k'
								}
								return '{{ $currency_symbol }}' + value
							}
						}, ticksStyle)
					}],
					xAxes: [{
						display: true,
						gridLines: {
							display: false
						},
						ticks: ticksStyle
					}]
				}
			}
		})
	})
</script>
@endsection